% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rif.R
\name{get_rif_variance}
\alias{get_rif_variance}
\title{Estimate RIF of variance}
\usage{
get_rif_variance(dep_var, weights)
}
\arguments{
\item{dep_var}{dependent variable of a distributional function. Discrete or continuous numeric vector.}

\item{weights}{numeric vector of non-negative observation weights, hence of same length as \code{dep_var}.
The default (\code{NULL)} is equivalent to \code{weights = rep(1, length(dep_var))}.}
}
\value{
A data frame with one column containing the RIF of the variance for each observation and one column containing the weights.
}
\description{
Function to estimate the recentered influence function (RIF) of the variance
of a weighted distribution of a dependent variable.
}
\examples{

dep_var <- c(1, 3, 9, 16, 3, 7, 4, 9)
weights <- c(2, 1, 3, 4, 4, 1, 6, 3)
get_rif_variance(dep_var, weights = weights)

}
