% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/italic_distribution_map.R
\name{italic_distribution_map}
\alias{italic_distribution_map}
\title{Create distribution map of a lichen taxon}
\usage{
italic_distribution_map(sp_name, plot_map = TRUE)
}
\arguments{
\item{sp_name}{Character string representing the accepted scientific name of a lichen
species.}

\item{plot_map}{If TRUE (default) the function returns a ggplot graph, if FALSE returns a sf object}
}
\value{
if plot_map = TRUE (default) a \code{ggplot} object representing the distribution map where Italian areas are colored according to the species' commonness/rarity. If plot_map = FALSE the sf object used to create the plot
}
\description{
Creates a distribution map for a given lichen species based on its commonness/rarity
status across Italian ecoregions and presence/absence across administrative regions.
The map visually represents the data obtained from
\code{italic_ecoregions_distribution()} and \code{italic_regions_distribution()}.
}
\details{
The function internally utilizes \code{italic_ecoregions_distribution()} and \code{italic_regions_distribution()} to retrieve the commonness/rarity
status across Italian ecoregions and presence/absence across administrative regions data for the provided species.
It then joins this data with a geospatial dataset of Italian regions and ecoregions (included in the package) to generate the map.

Commonness/rarity categories are visualized with a color scale, where each color
corresponds to a different level of commonness/rarity ("extremely common", "very common",
"common", "rather common", "rather rare", "rare", "very rare", "extremely rare", "absent").
}
\note{
Before using this function, ensure that you have obtained the accepted name of the
lichen using \code{italic_match()}.
Example workflow:
\preformatted{
      name_matched <- italic_match("Cetraria islandica")
      map <- italic_distribution_map(name_matched$accepted_name)
      }
}
\examples{
\dontrun{
italic_distribution_map("Flavoparmelia caperata (L.) Hale")
italic_distribution_map("Anisomeridium biforme (Schaer.) R.C. Harris")
}

}
\references{
For more information about Italian ecoregions see ITALIC ecoregions distribution
\url{https://italic.units.it/?procedure=base&t=59&c=60#commonness}
and the scientific publication describing the ecoregions used in ITALIC
\url{https://www.mdpi.com/1424-2818/12/8/294}
}
