% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{mouthdist}
\alias{mouthdist}
\title{Distance From Mouth}
\usage{
mouthdist(seg, vert, rivers, stopiferror = TRUE, algorithm = NULL)
}
\arguments{
\item{seg}{Vector of segments}

\item{vert}{Vector of vertices}

\item{rivers}{The river network object to use}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found,
the function will return \code{NA} in the appropriate entry.  Defaults to \code{TRUE}.  See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
Distance (numeric)
}
\description{
Calculates distance from river locations (given as vectors of segment and
  vertex) and the specified mouth of the river network.  The mouth must first
  be specified (see \link{setmouth}).
}
\note{
Building routes from the river mouth to each river network segment and/or distance lookup tables will
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk)

# Mouth must be specified
Gulk$mouth$mouth.seg <- 1
Gulk$mouth$mouth.vert <- 1

mouthdist(seg=4, vert=40, rivers=Gulk)
mouthdist(seg=c(4,5), vert=c(40,20), rivers=Gulk)
}
\author{
Matt Tyers
}
