% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverdist_1.R
\name{segvert2xy}
\alias{segvert2xy}
\title{Convert River Locations to XY coordinates}
\usage{
segvert2xy(seg, vert, rivers)
}
\arguments{
\item{seg}{A vector of river segments to transform}

\item{vert}{A vector of river vertices to transform}

\item{rivers}{The river network object to use}
}
\value{
A data frame of XY coordinates, given as \code{$snap_x} and \code{$snap_y}..
}
\description{
This function is almost the reverse of \link{xy2segvert}, and
returns a data frame of the XY spatial coordinates corresponding to vectors
of segment and vertex.  It should be noted that this only returns the spatial
coordinates from the river network itself, and will not necessarily correspond
to the original set of point data.
}
\examples{
data(Gulk,fakefish)
head(fakefish)

xy_from_segvert <- segvert2xy(seg=fakefish$seg, vert=fakefish$vert, 
                   rivers=Gulk)
head(xy_from_segvert)

plot(x=Gulk, xlim=c(862000,882000), ylim=c(6978000,6993000))
points(x=fakefish$x, y=fakefish$y, pch=16, col=2)

points(x=xy_from_segvert$snap_x, y=xy_from_segvert$snap_y, pch=15, col=4)
}
\seealso{
\link{xy2segvert}, \link{pointshp2segvert}
}
\author{
Matt Tyers
}
