% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qjqpd.R
\name{qjqpd}
\alias{qjqpd}
\title{Quantile function of Johnson Quantile-Parameterised Distribution.}
\usage{
qjqpd(p, params)
}
\arguments{
\item{p}{vector of probabilities}

\item{params}{jqpd object created using \code{jqpd()}}
}
\value{
A numeric vector of quantiles corresponding to the p probability
  vector
}
\description{
Quantile function of Johnson Quantile-Parameterised Distribution.
}
\examples{
x <- c(0.32, 0.40, 0.60)
params <- jqpd(x, lower = 0, upper = 1, alpha = 0.1)
probs <- seq(0.01, 0.99, 0.01)
quantiles <- qjqpd(p = probs, params)
}
