% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlcv_d.R
\name{rlcv_d}
\alias{rlcv_d}
\title{Robust likelihood cross validation bandwidth for multivariate kernel densities}
\usage{
rlcv_d(x.obs, x.new = NULL)
}
\arguments{
\item{x.obs}{Training (observed) data (n1 by d matrix, d>=2)}

\item{x.new}{Evaluation data (n2 by d matrix, d>=2); default to x.obs}
}
\value{
fhat: density evaluated at x.new; h: bandwidth
}
\description{
Robust likelihood cross validation bandwidth for multivariate kernel densities
}
\examples{
# old faithful data
x=datasets::faithful
x=cbind(x[,1],x[,2])
fit=rlcv_d(x.obs=x)
# evaluation data
x1=seq(min(x[,1])*.8,max(x[,1])*1.2,length=30)
x2=seq(min(x[,2])*.8,max(x[,2])*1.2,length=30)
x11=rep(x1,each=30)
x22=rep(x2,30)
fhat=kde_d(x.new=cbind(x11,x22),x.obs=x,h=fit$h)
persp(x1,x2,matrix(fhat,30,30))
}
\references{
Wu, Ximing (2019), "Robust Likelihood Cross Validation for Kernel Density Estimation," Journal of Business and Economic Statistics, 37(4): 761-770.
}
\author{
Ximing Wu \email{xwu@tamu.edu}
}
