% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{Extract.rle}
\alias{Extract.rle}
\alias{[.rle}
\alias{[<-.rle}
\alias{[[.rle}
\alias{[[<-.rle}
\alias{$.rle}
\alias{$<-.rle}
\title{Indexing Methods for \code{rle} Objects}
\usage{
\method{[}{rle}(x, i, ..., unclass = getOption("rle.unclass_index") \%||\% FALSE)

\method{[}{rle}(x, i, ..., unclass = getOption("rle.unclass_index") \%||\% FALSE) <- value

\method{[[}{rle}(x, i, ..., unclass = getOption("rle.unclass_index") \%||\% FALSE)

\method{[[}{rle}(x, i, ..., unclass = getOption("rle.unclass_index") \%||\% FALSE) <- value

\method{$}{rle}(x, name)

\method{$}{rle}(x, name) <- value
}
\arguments{
\item{x, i, name, value, ...}{Arguments to indexing operators. See
\link{Extract} documentation in the \pkg{base} package.}

\item{unclass}{Logical: whether to process the arguments as if for
an ordinary list; default other than \code{FALSE} can be set with
\code{options(rle.unclass_index=...)}.}
}
\value{
For character indices, the corresponding sublists or
elements of the \code{rle} object; for numeric indices, for \code{[[} the
element at the specified position and for \code{[} an \code{rle} containing the
elements at the specified position(s).
}
\description{
These methods provide indexing functionality for
\code{\link{rle}} objects on the scale of the original scale (the elements
of the vector that was compressed) where possible.
}
\details{
At this time, the \pkg{rle} following form of indexing are
supported:

\tabular{lll}{
\strong{operation} \tab \strong{index} \tab \strong{effect} \cr
\code{[} \tab \code{numeric >= 0} \tab as vector \cr
\code{[} \tab \code{numeric < 0} \tab no \cr
\code{[} \tab \code{logical} \tab no \cr
\code{[} \tab \code{character} \tab on rle \cr
\verb{[<-} \tab \code{numeric >= 0} \tab no \cr
\verb{[<-} \tab \code{numeric < 0} \tab no \cr
\verb{[<-} \tab \code{logical} \tab no \cr
\verb{[<-} \tab \code{character} \tab on rle \cr
\code{[[} \tab \code{numeric} \tab as vector \cr
\verb{[[<-} \tab \code{numeric} \tab no \cr
\code{[[} \tab \code{character} \tab on \code{rle} \cr
\verb{[[<-} \tab \code{character} \tab on \code{rle} \cr
\code{$} \tab \code{character} \tab on \code{rle} \cr
\verb{$<-} \tab \code{character} \tab on \code{rle}
}

Generally, character indexes will access the underlying elements of
the \code{\link{rle}} object, \verb{$lengths} and \verb{$values}.
}
\note{
Some of these methods and inputs produce an error in
order to future-proof code that depends on the \code{rle} package by
preventing their use.
}
\examples{

# Indexing by character or by $ works, including sub-indexing.
x <- rle(1:5)
x[["values"]] <- 2:6
x
x$values[2:3] <- 7:8
x

# From example(rle):
z <- c(TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, TRUE)
rle(z)
rle(z)[3:5] # Extract a sub-rle
rle(z)[[4]] # Extract an element

stopifnot(identical(inverse.rle(rle(z)[3:5]), z[3:5]))
# Fractional:
stopifnot(identical(inverse.rle(rle(z)[3.5]), z[3.5]))
# Zero:
stopifnot(identical(inverse.rle(rle(z)[0]), z[0]))
# Out of range:
stopifnot(identical(inverse.rle(rle(z)[20]), z[20]))
# A mix:
strange <- c(20, 3:5, 0, NA, 1:2)
stopifnot(identical(inverse.rle(rle(z)[strange]), z[strange]))
}
\seealso{
\code{\link[=index_to_run]{index_to_run()}}
}
