% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/three_methods.r
\name{GEER_est}
\alias{GEER_est}
\title{GEER: General Estimating Equation Rank-Based Estimation Method}
\usage{
GEER_est(x, y, I, sec, mat, school, section, weight = "wil",
  rprpair = "hl-disp", verbose = FALSE)
}
\arguments{
\item{x}{Design matrix, pxn, without intercept.}

\item{y}{Response vector of nx1.}

\item{I}{Number of clusters.}

\item{sec}{A vector of subcluster numbers in clusters.}

\item{mat}{A matrix of numbers of observations in subclusters.  Dimension is
Ixmax(number ofsubclusters). Each row indicates one cluster.}

\item{school}{A vector of clusters, nx1.}

\item{section}{A vector of subclusters, nx1.}

\item{weight}{When weight="hbr", it uses hbr weights in GEE weights. By
default, ="wil", it uses Wilcoxon weights. See the theory in the references.}

\item{rprpair}{By default, it uses "hl-disp" in the random prediction
procedure (RPP). Also, "med-mad" would be an alternative.}

\item{verbose}{Boolean indicating whether to print out diagnostic messages.}
}
\value{
\item{theta}{ Fixed effect estimates. }
  \item{ses}{ Standard error for the fixed esimates. }
  \item{sigma}{ Variances of cluster, subcluster, and residual. }
  \item{ehat}{ Raw error. }
  \item{ehats}{ Independence error from last weighted step. }
  \item{effect_sch}{ Cluster random error. }
  \item{effect_sec}{ Subcluster random error. }
  \item{effect_err}{ Epsilon error. }
}
\description{
The package rlme calls this function for gee method, one of the methods
proposed in Bilgic's study (2012). Also see Kloke et al. (2013).  %% ~~ A
concise (1-5 lines) description of what the function does. ~~
}
\examples{

# See the rlme function.

}
\references{
Y. K. Bilgic. Rank-based estimation and prediction for mixed
effects models in nested designs. 2012. URL
http://scholarworks.wmich.edu/dissertations/40. Dissertation.

A. Abebe, J. W. McKean, J. D. Kloke and Y. K. Bilgic. Iterated reweighted
rank-based estimates for gee models. 2013. Submitted.
}
\seealso{
rlme, GR_est, JR_est, rprmeddisp
}
\author{
Yusuf K. Bilgic, yekabe@hotmail.com
}
\keyword{models}
