% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_vignette.R
\name{html_vignette}
\alias{html_vignette}
\title{Convert to an HTML vignette}
\usage{
html_vignette(
  fig_width = 3,
  fig_height = 3,
  dev = "png",
  df_print = "default",
  css = NULL,
  highlight = "pygments",
  keep_md = FALSE,
  readme = FALSE,
  self_contained = TRUE,
  tabset = FALSE,
  code_folding = c("none", "show", "hide"),
  extra_dependencies = NULL,
  pandoc_args = NULL,
  ...
)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{dev}{Graphics device to use for figure output (defaults to png)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses a corresponding S3 method of \code{print}, typically
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}. See
\href{https://bookdown.org/yihui/rmarkdown/html-document.html#data-frame-printing}{Data
frame printing section} in bookdown book for examples.}

\item{css}{One or more css files to include.}

\item{highlight, ...}{Additional arguments passed to
\code{\link[=html_document]{html_document()}}. Please note that \code{theme} and
\code{fig_retina} are hard-coded. Setting any of those will yield an error.}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{readme}{Use this vignette as the package README.md file (i.e. render
it as README.md to the package root). Note that if there are image files
within your vignette you should be sure to add \file{README_files} to \file{.Rbuildignore}.}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
its size).}

\item{tabset}{Opt-in tabbed-sections feature inspired by \code{\link[=html_document]{html_document()}}.
See section "Tabbed Sections" for the detail.
This feature also allows navigation to the tab from table of contents and URL.}

\item{code_folding}{Enable document readers to toggle the display of R code
chunks. Specify \code{"none"} to display all code chunks. Specify
\code{"hide"} or \code{"show"} to hide or show all R code chunks by
default, and let readers toggle the states on browsers. See the
\emph{Code folding}}

\item{extra_dependencies}{Extra dependencies as a list of the
\code{html_dependency} class objects typically generated by
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
R Markdown output format to pass to \code{\link[=render]{render()}}
}
\description{
A HTML vignette is a lightweight alternative to \code{\link[=html_document]{html_document()}}
suitable for inclusion in packages to be released to CRAN. It reduces the
size of a basic vignette from 100k to around 10k.
}
\details{
Compared to \code{\link[=html_document]{html_document()}}, it:
\itemize{
\item never uses retina figures
\item never uses a theme
\item has a smaller default figure size
\item uses a custom css stylesheet
}

See the \href{https://bookdown.org/yihui/rmarkdown/r-package-vignette.html}{online documentation}
for additional details on using the \code{html_vignette()} format.
}
\section{Tabbed Sections}{


You can organize content using tabs by applying the \code{.tabset} class
attribute to headers within a document. This will cause all sub-headers of
the header with the \code{.tabset} attribute to appear within tabs rather
than as standalone sections. For example:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{## Quarterly Results \{.tabset\}

### By Product

### By Region
}\if{html}{\out{</div>}}

With \code{\link[=html_document]{html_document()}}, you can also specify two additional attributes to
control the appearance and behavior of the tabs. The \code{.tabset-fade}
attributes causes the tabs to fade in and out when switching. The
\code{.tabset-pills} attribute causes the visual appearance of the tabs to
be "pill" rather than traditional tabs. For example:

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{## Quarterly Results \{.tabset .tabset-fade .tabset-pills\}
}\if{html}{\out{</div>}}

If tabbed sections relies on \code{\link[=html_dependency_tabset]{html_dependency_tabset()}}, for example by
\code{\link[=html_vignette]{html_vignette()}}, these two attributes are not supported.
}

\section{Code folding}{


Code blocks become foldable by specifying "show" or "hide" to the
\code{code_folding} parameter. The state can be toggled individually on
browsers. The document-wide toggle button is also provided for
\code{html_document} and some of its extensions such as
\code{html_notebook}. Note that this feature applies not only to source
codes of chunks, but also markdown code blocks.

Supported languages are R, Python, Bash, SQL, C++, Stan, and Julia. To
support code blocks with other languages, add \code{foldable} class to them
(i.e., \code{class.source = "foldable"} as a chunk option).

The default initial state of code folding respects the value given to the
\code{code_folding} parameter. To override the behavior individually, add
\code{fold-none} to disable, \code{fold-hide} to initially hide,
\code{fold-show} to initially show.
}

