% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonStatsAndPlots.R
\docType{methods}
\name{plotCombinedMatrix}
\alias{plotCombinedMatrix}
\alias{plotCombinedMatrix,rnaCrosslinkDataSet-method}
\title{Plots a contact map of two chosen samples for chosen stages in the analysis, with each chosen sample on separate halves of the contact map}
\usage{
plotCombinedMatrix(
  cds,
  type1 = "original",
  type2 = "original",
  sample1 = 1,
  sample2 = 1,
  directory = 0,
  a = 1,
  b = 50,
  c = 1,
  d = 50,
  h = 3,
  returnData = FALSE
)
}
\arguments{
\item{cds}{A rnaCrosslinkDataSet object}

\item{type1}{The analysis stage to plot on the upper half of the heatmap}

\item{type2}{The analysis stage to plot on the lower half of the heatmap}

\item{sample1}{The sample number to plot on the upper half of the heatmap}

\item{sample2}{The sample number to plot on the upper half of the heatmap}

\item{directory}{An output directory for the heatmap (use 0 for no output)}

\item{a}{To make a subsetted plot (left value on x)}

\item{b}{To make a subsetted plot (right value on x)}

\item{c}{To make a subsetted plot (left value on y)}

\item{d}{To make a subsetted plot (right value on y)}

\item{h}{Height of image (inches) (only useful if plotting)}

\item{returnData}{if TRUE matrix is returned instead of plotting}
}
\value{
A heatmap of the reads of the chosen sample numbers, in the analysis stages chosen, with each chosen sample on a separate half of the heatmap
}
\description{
Plots a contact map of two chosen samples for chosen stages in the analysis, with each chosen sample on separate halves of the contact map
}
\examples{
cds = makeExamplernaCrosslinkDataSet()

plotCombinedMatrix(cds,
            type1 = "original",
            type2 = "noHost",
            b = rnaSize(cds),
            d = rnaSize(cds))
}
