% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transformations.R
\name{trapzc}
\alias{trapzc}
\title{Trapezoidal formula for numerical integration}
\usage{
trapzc(step, f)
}
\arguments{
\item{step}{step of the grid}

\item{f}{grid evaluation of density}
}
\value{
\item{\code{int}}{The value of integral computed numerically by trapezoidal formula.}
}
\description{
Numerical integration via trapezoidal formula.
}
\examples{
# Example (zero-integral of fcenLR density)
t = seq(-4.7,4.7, length = 1000)
t_step = diff(t[1:2])
mean = 0; sd = 1.5
f = dnorm(t, mean, sd)
f.fcenLR = fcenLR(t,t_step,f)
trapzc(t_step,f.fcenLR)
}
\author{
R. Talska\email{talskarenata@seznam.cz}, K. Hron\email{karel.hron@upol.cz}
}
