% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationEstimators.R
\name{trim_mean}
\alias{trim_mean}
\title{Trimmed mean}
\usage{
trim_mean(x, gamma = 0.2, na.rm = FALSE)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{gamma}{a numeric value in [0, 0.5] specifying the fraction of observations
to be trimmed from each end of the sample before calculating the
mean. The default value is 0.2.}

\item{na.rm}{a logical value indicating whether NA values in \code{x} and
\code{y} should be stripped before the computation proceeds. The
default is \code{na.rm = FALSE}.}
}
\value{
The trimmed mean.
}
\description{
\code{trim_mean} calculates a trimmed mean of a sample.
}
\details{
This is a wrapper function for the function \code{\link[base]{mean}}.
}
\examples{
# Generate random sample
set.seed(108)
x <- rnorm(10)

# Compute 20\% trimmed mean
trim_mean(x, gamma = 0.2)

}
