% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleEstimators.R
\name{win_var}
\alias{win_var}
\title{Winsorized variance}
\usage{
win_var(x, gamma = 0, na.rm = FALSE)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{gamma}{a numeric value in [0, 0.5] specifying the fraction of observations
to be replaced at each end of the sample before calculating the
mean. The default value is 0.2.}

\item{na.rm}{a logical value indicating whether NA values in \code{x} and
\code{y} should be stripped before the computation proceeds. The
default is \code{na.rm = FALSE}.}
}
\value{
A named list containing the following items:
\item{var}{winsorized variance.}
\item{h}{degrees of freedom used for tests based on trimmed means and the
winsorized variance.}
}
\description{
\code{win_var} calculates the winsorized variance of a sample.
}
\examples{
# Generate random sample
set.seed(108)
x <- rnorm(10)

# Compute 20\% winsorized variance
win_var(x, gamma = 0.2)

}
