% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kobo_audit.R
\name{kobo_audit}
\alias{kobo_audit}
\title{Get all audit logs data from a KoboToolbox survey}
\usage{
kobo_audit(x, progress)
}
\arguments{
\item{x}{the unique identifier of a specific asset (\code{character}) or
a \code{kobo_asset} object.}

\item{progress}{logical, whether or not you want to see the progess via message.
Default to \code{FALSE}.}
}
\value{
A \code{data.frame}. It contains survey paradata from audit logs.
The following columns are available:
\itemize{
\item \verb{_id}  This columns generated by \code{robotoolbox} allow you to do a mapping
the \verb{_id} of the submissions in \code{kobo_data}.
\item \code{event} the action that took place. The different event types include.
form start, form exit, question, group questions, end screen, and device
or metadata audit.
\item \code{node} the name of the question or group related to the event.
\item \code{name} This column is appended by \code{robotoolbox} to match the name of the question
in the audit and the data from \code{kobo_data}.
\item \code{start} the timestamp when the event started.
\item \code{end} the timestamp when the event ended.
\item \code{latitude} the latitude of the device when the event occurred.
\item \code{longitude} the longitude of the device when the event occurred.
\item \code{accuracy} the GPS accuracy of the location data.
\item \code{old-value} the previous value of the question before it was changed in this event.
\item \code{new-value} the new value of the question after it was changed in this event.
\item \code{user} the username of the data collector.
\item \code{change-reason} the reason before they save changes to a form.
}
}
\description{
Get all audit logs data from a KoboToolbox survey through a \code{kobo_asset} or
asset unique identifier.
}
\examples{
\dontrun{
kobo_setup()
uid <- "a9cwEQcbWqWzdA5eqkjRUWi"
asset <- kobo_asset(uid)
audit <- kobo_audit(asset)

if (require(dplyr)) {
 library(dplyr)
 glimpse(audit)
 }
}

}
