% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{robservableProxy}
\alias{robservableProxy}
\title{Send commands to a Proxy instance in a Shiny app}
\usage{
robservableProxy(
  id,
  session = shiny::getDefaultReactiveDomain(),
  deferUntilFlush = TRUE
)
}
\arguments{
\item{id}{single-element character vector indicating the output ID of the
robservable to modify (if invoked from a Shiny module, the namespace will be added
automatically)}

\item{session}{the Shiny session object to which the robservable belongs; usually the
default value will suffice}

\item{deferUntilFlush}{indicates whether actions performed against this
instance should be carried out right away, or whether they should be held
until after the next time all of the outputs are updated; defaults to
\code{TRUE}}
}
\value{
A proxy object which allows to update an already created robservable instance.
}
\description{
Creates a robservable-like object that can be used to customize and control a robservable
that has already been rendered. For use in Shiny apps and Shiny docs only.
}
\details{
Normally, you create a robservable instance using the \code{\link{robservable}} function.
This creates an in-memory representation of a robservable that you can customize,
print at the R console, include in an R Markdown document, or render as a Shiny output.

In the case of Shiny, you may want to further customize a robservable, even after it
is rendered to an output. At this point, the in-memory representation of the
robservable is long gone, and the user's web browser has already realized the
robservable instance.

This is where \code{robservableProxy} comes in. It returns an object that can
stand in for the usual robservable object. The usual robservable functions
can be called, and instead of customizing an in-memory representation,
these commands will execute on the already created robservable instance in
the browser.
}
