% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustSFM.R
\name{summary.rsfa}
\alias{summary.rsfa}
\title{Summary Method for Class \code{rsfa}}
\usage{
\method{summary}{rsfa}(object, ...)
}
\arguments{
  \item{object}{An object of class \code{rsfa}.}

  \item{...}{Unused.}
}
\value{
  A summary table with estimates, standard errors, z-values, \emph{p}-values,
  and significance codes.
}
\description{
  This function provides a summary of the MDPD estimation, including
  coefficient estimates, standard errors, z-values, \emph{p}-values, and significance codes.
}
\examples{
## Example using the 'riceProdPhil' dataset from the `frontier` package
library(frontier)
data(riceProdPhil)

my.model <- log(PROD) ~ log(AREA) + log(LABOR) + log(NPK) + log(OTHER)
fit.ml <- rsfa(my.model, data = riceProdPhil)
summary(fit.ml)
fit.mdpde<- rsfa(my.model, data = riceProdPhil, alpha = 0.1)
summary(fit.mdpde)
}
