#' Health Insurance Coverage
#'
#' A dataset containing the proportion of the population from several cities
#' of the state of São Paulo, Brazil, in 2010.
#'
#' @format A data frame with 80 rows and 4 variables:
#' \describe{
#'   \item{CITY}{the corresponding city.}
#'   \item{URB}{proportion of the total population living in the
#'       city’s urban zone.}
#'   \item{GDP}{per capita gross domestic product.}
#'   \item{HIC}{the health insurance coverage index.}
#' }
#' @details This dataset was collected by the Institute of Applied Economic
#'     Research (Instituto de Pesquisa Econômica Aplicada, IPEA, Brazil). It
#'     includes information on 80 cities in the state of São Paulo, Brazil,
#'     in 2010.
#' @source \url{http://www.ipeadata.gov.br/Default.aspx}
#' @usage data("HIC", package = "robustbetareg")
"HIC"
