% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commands.R
\name{rockr.commands}
\alias{rockr.commands}
\title{List the asynchronous commands}
\usage{
rockr.commands(conn, df = TRUE)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{df}{Return a data.frame (default is TRUE)}
}
\value{
The data.frame of command objects, one column per property.
}
\description{
Get the list of asynchronous R commands in the remote R session.
}
\examples{
\dontrun{
conn <- rockr.connect(username='user', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.open(conn)
rockr.commands(conn)
rockr.close(conn)
}
}
\seealso{
Other command functions: 
\code{\link{rockr.command_result}()},
\code{\link{rockr.command_rm}()},
\code{\link{rockr.commands_rm}()},
\code{\link{rockr.command}()}
}
\concept{command functions}
