% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connection.R
\name{rockr.connect}
\alias{rockr.connect}
\title{Rocker connection}
\usage{
rockr.connect(
  username = getOption("rock.username"),
  password = getOption("rock.password"),
  url = getOption("rock.url"),
  opts = getOption("rock.opts", list())
)
}
\arguments{
\item{username}{User name in Rocker R server. Can be provided by "rock.username" option.}

\item{password}{User password in Rocker R server. Can be provided by "rock.password" option.}

\item{url}{Rocker R server url. Can be provided by "rock.url" option.}

\item{opts}{Curl options as described by httr (call httr::httr_options() for details). Can be provided by "rock.opts" option.}
}
\value{
A rockr connection object.
}
\description{
Connect with Rocker.
}
\examples{
\dontrun{
#### The below examples illustrate the different ways to connect to rockr ####

# explicit username/password connection
conn <- rockr.connect(username='administrator', password='password',
                    url='https://rocker-demo.obiba.org')

# explicit access token connection
conn <- rockr.connect(token='HYG16LO0VaX4O0UardNbiqmr2ByBpRke',
                    url='https://rocker-demo.obiba.org')

# connect using options and user credentials
options(rockr.username='administrator',
 rockr.password='password',
 rockr.url='https://rocker-demo.obiba.org')
conn <- rockr.connect()

# connect using options and personal access token
options(rockr.token='HYG16LO0VaX4O0UardNbiqmr2ByBpRke',
 rockr.url='https://rocker-demo.obiba.org')
conn <- rockr.connect()

# connect using ssl key pair
options(rockr.opts=list(
   sslcert='my-publickey.pem',
   sslkey='my-privatekey.pem'))
conn <- rockr.connect(url='https://rocker-demo.obiba.org')
}
}
\seealso{
Other connection functions: 
\code{\link{rockr.close}()},
\code{\link{rockr.open}()}
}
\concept{connection functions}
