% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sessions.R
\name{rockr.sessions}
\alias{rockr.sessions}
\title{List of the R sessions}
\usage{
rockr.sessions(conn, subject = NULL)
}
\arguments{
\item{conn}{A rockr connection object.}

\item{subject}{Filter by subject name owning the sessions (requires administrator or manager role to be effective).}
}
\value{
The list of the R session objects.
}
\description{
Get the list of the R sessions. Users with administrator or manager role can list the R sessions. Regular users
can only list their own.
}
\examples{
\dontrun{
conn <- rockr.connect(username='administrator', password='password',
                      url='https://rocker-demo.obiba.org')
rockr.sessions(conn)
}
}
\seealso{
Other administration functions: 
\code{\link{rockr.log}()},
\code{\link{rockr.package_install}()},
\code{\link{rockr.package_rm}()},
\code{\link{rockr.packages_datashield}()},
\code{\link{rockr.packages_rm}()},
\code{\link{rockr.packages}()},
\code{\link{rockr.package}()},
\code{\link{rockr.restart}()},
\code{\link{rockr.session_switch}()},
\code{\link{rockr.session}()},
\code{\link{rockr.start}()},
\code{\link{rockr.status}()},
\code{\link{rockr.stop}()},
\code{\link{rockr.version}()}
}
\concept{administration functions}
