% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{plot_roc}
\alias{plot_roc}
\title{Plot Receiver Operating Characteristic (ROC) curve using ggroc}
\usage{
plot_roc(
  y_true,
  y_score,
  col = "blue",
  size = 1.2,
  title = TRUE,
  summary = FALSE,
  ...
)
}
\arguments{
\item{y_true}{Response vector with class labels in \{-1, 1\}. Labels given as
\{0, 1\} or as a two-level factor/character are automatically converted
to this format.}

\item{y_score}{Numeric vector of predicted scores or decision values.}

\item{col}{Line color.}

\item{size}{Line width.}

\item{title}{Logical; if TRUE, displays AUC in the plot title.}

\item{summary}{Logical; if TRUE, prints the ROC object summary.}

\item{...}{Additional arguments passed to pROC::ggroc().}
}
\value{
A ggplot object of the ROC curve.
}
\description{
Draws an ROC curve based on decision values. There is an option to display
the AUC in the plot title and to print the ROC summary object.
}
\examples{
set.seed(123)
n <- 100
n_pos <- round(0.2 * n)
n_neg <- n - n_pos
X <- rbind(
  matrix(rnorm(2 * n_neg, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos, mean =  1), ncol = 2)
)
y <- c(rep(-1, n_neg), rep(1, n_pos))

fit <- roclearn(X, y, lambda = 0.1, approx=TRUE)

y_score <- predict(fit, X, type = "response")

plot_roc(y, y_score)
}
