% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocsvm.path.R
\name{rocsvm.path}
\alias{rocsvm.path}
\title{Fit the entire regularization path for ROC-Support Vector Machine (ROC-SVM)}
\usage{
rocsvm.path(x, y, rho = 1, kernel = poly.kernel, param.kernel = 1,
  prop = 0.5, lambda.min = 1e-05, eps = 1e-05, Nmoves = 500)
}
\arguments{
\item{x}{The data matrix (n x p) with n rows (observations) on p variables (columns)}

\item{y}{The \code{{-1, 1}} valued response variable.}

\item{rho}{A positive constant}

\item{kernel}{This is a user-defined function. Provided options are polynomial kernel; \code{poly} (the default, with parameter set to default to a linear kernel) and radial kernel; \code{radial}.}

\item{param.kernel}{The parameter(s) for the kernel. For this radial kernel, the parameter is known in the fields as "gamma". For the polynomial kernel, it is the "degree"}

\item{prop}{The proportion of large class corresponding a point of small class by speed-up tricks (the default is \code{prop = 0.5}). If you don't want to use the "speed-up tricks", then set \code{prop} to 1.}

\item{lambda.min}{The smallest value of lambda for termination of the algorithm (the default is \code{lambda.min = 1e-05}).}

\item{eps}{An adjustment computing errors}

\item{Nmoves}{The maximum number of iterations the rocsvm.path algorithm}
}
\value{
A 'rocsvm.path' object is returned, for which there are \code{lambda} values and corresponding values of \code{alpha} for each data point.
}
\description{
This algorithm computes the entire regularization path for the ROC-Support Vector Machine with a relatively low cost compared to quadratic programming problem.
}
\examples{
library(rocsvm.path)
n <- 30
p <- 2
delta <- 1
set.seed(309)
y <- c(rep(1, n/2), rep(-1, n/2))
x <- matrix(0, n, p)
for (i in 1:n){
 if (y[i] == 1) {
 x[i,] <- rnorm(p, -delta, 1)
 } else {
 x[i,] <- rnorm(p, delta, 1)
  }
 }

rho = 1
kernel = radial.kernel
param.kernel  = 1/ncol(x)
prop = 0.1
obj <- rocsvm.path(x, y, rho, kernel, param.kernel, prop)
}
\seealso{
\code{\link{rocsvm.get.solution}}, \code{\link{plot.rocsvm}},  \code{\link{rocsvm.intercept}}
}
\author{
Seung Jun Shin, Do Hyun Kim
}
