% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollup.R
\name{grouping_sets}
\alias{grouping_sets}
\title{grouping_sets}
\usage{
grouping_sets(df, ...)
}
\arguments{
\item{df}{dataframe or grouped df}

\item{...}{grouping variables}
}
\value{
A list of 'grouped_df' class. each 'grouped_df' object has a different grouping level.
}
\description{
Compute total amounts at different group levels, producing multiple subtotals. With the 'grouping_sets' clause following 'group_by', you can aggregate multiple grouping variables in one operation. This reflects the 'GROUPING SETS' operations in 'SQL'.
}
\examples{
mtcars \%>\% group_by(vs, am) \%>\% grouping_sets("vs","am",c("vs","am")) 
mtcars \%>\% group_by(vs, am) \%>\% with_rollup() 
mtcars \%>\% group_by(vs, am) \%>\% with_cube() 
}
