% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lists.R
\name{create_ppm_blacklist}
\alias{create_ppm_blacklist}
\title{Create blacklist commands for Posit Package Manager}
\usage{
create_ppm_blacklist(rosv_query, flags = NULL)
}
\arguments{
\item{rosv_query}{A table of vulnerabilities (created via \code{osv_query()}).}

\item{flags}{Global flag to append to commands.}
}
\value{
Character vector containing blacklist commands.
}
\description{
Use OSV data accessed via \code{\link{osv_query}} to create blacklist (i.e. blocklist)
commands for the Posit Package Manager product.
}
\details{
Although OSV has many databases for open source software, this function is
only relevant for CRAN/Bioconductor and PyPI. To ensure the blacklist is applied to the
appropriate target, it is encouraged to specify the name of the source used in your configuration
as an additional flag parameter (see examples). Only one ecosystem can be used at a time to ensure
there is not a mix of packages across ecosystems applied to incompatible sources.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Blacklist all CRAN package versions with a listed vulnerability
cran_vul <- osv_query(ecosystem = 'CRAN', all_affected = FALSE)
cmd_blist <- create_ppm_blacklist(cran_vul, flags = '--source=cran')
\dontshow{\}) # examplesIf}
}
