% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ieee-754.R
\name{ieee-754}
\alias{ieee-754}
\alias{round_ties_to_even}
\alias{round_ties_to_away}
\alias{round_toward_positive}
\alias{round_toward_negative}
\alias{round_toward_zero}
\title{IEEE 754 rounding standard}
\usage{
round_ties_to_even(x, digits = 0, ...)

round_ties_to_away(x, digits = 0)

round_toward_positive(x, digits = 0)

round_toward_negative(x, digits = 0)

round_toward_zero(x, digits = 0)
}
\arguments{
\item{x}{Numeric. The decimal number to round.}

\item{digits}{Integer. Number of digits to round \code{x} to. Default is \code{0}.}

\item{...}{Only in \code{round_ties_to_even()}. Passed down to \code{\link[base:Round]{base::round()}}.}
}
\value{
Numeric. \code{x} rounded to \code{digits}.
}
\description{
These functions implement the industry standard IEEE 754:
\itemize{
\item \code{round_ties_to_even()} rounds to the nearest value. If both are at equal
distance, it tends to round to the even number (see \code{\link[base:Round]{base::round()}} for
details).
\item \code{round_ties_to_away()} rounds to the nearest value. If both are at equal
distance, it rounds to the number with the greater absolute value, i.e.,
the number that is further away from zero.
\item \code{round_toward_positive()} always rounds to the greater of the two nearest
values. This is like ceiling at a given number of decimal places.
\item \code{round_toward_negative()} always rounds to the lesser of the two nearest
values. This is like flooring at a given number of decimal places.
\item \code{round_toward_zero()} always rounds to the number with the lower absolute
value, i.e., the number that is closer to zero. This is like truncation at
a given number of decimal places.
}
}
\details{
The function names follow the official standard except for case
conventions (IEEE 2019, pp. 27f.; the \href{https://en.m.wikipedia.org/wiki/IEEE_754#Rounding_rules}{Wikipedia page} is more
accessible but uses slightly different names).

Internally, these functions are just wrappers around other roundwork
functions as well as \code{\link[base:Round]{base::round()}}. They are presented here for easy
compliance with the IEEE 754 standard in R.
}
\examples{
# Round to the nearest value. In case of a tie,
# the result is hard to predict but tends to be even:
round_ties_to_even(1.25, digits = 1)
round_ties_to_even(-1.25, digits = 1)

# Round to the nearest value. In case of a tie,
# round away from zero:
round_ties_to_away(1.25, digits = 1)
round_ties_to_away(-1.25, digits = 1)

# Always round to the greater value:
round_toward_positive(0.721, digits = 2)
round_toward_positive(-0.721, digits = 2)

# Always round to the lesser value:
round_toward_negative(3.249, digits = 2)
round_toward_negative(-3.249, digits = 2)

# Always round toward zero:
round_toward_zero(6.38, digits = 1)
round_toward_zero(-6.38, digits = 1)
}
\references{
IEEE (2019). \emph{IEEE Standard for Floating-Point Arithmetic.}
https://doi.org/10.1109/IEEESTD.2019.8766229
}
