% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_config.R
\name{convert_config_helpers}
\alias{convert_config_helpers}
\alias{make_config_edits}
\alias{guess_dcf_indent}
\alias{update_config_needs}
\alias{update_config_roxygen_meta}
\alias{update_config_roxygen_desc}
\alias{update_config_roxygen_expr}
\title{Tools for modifying configuration files}
\usage{
make_config_edits(path)

guess_dcf_indent(dcf)

update_config_needs(dcf)

update_config_roxygen_meta(path)

update_config_roxygen_desc(dcf)

update_config_roxygen_expr(expr)
}
\arguments{
\item{path}{(\code{character[1]}) A file path within the package directory.}

\item{dcf}{(\code{data.frame}) The result of \code{\link[=read.dcf]{read.dcf()}} on the package description file.}

\item{expr}{(\code{expression}) The parsed contents of an \code{R}-formatted config entry.}
}
\description{
Tools for modifying configuration files
}
\section{Functions}{
\itemize{
\item \code{make_config_edits()}: Make edits to various configuration files

\item \code{guess_dcf_indent()}: Guess the existing dcf indentation

\item \code{update_config_needs()}: Update the Needs section of a DESCRIPTION file

\item \code{update_config_roxygen_meta()}: Update the Roxygen man/roxygen/meta.R file

\item \code{update_config_roxygen_desc()}: Update the Roxygen DESCRIPTION entry

\item \code{update_config_roxygen_expr()}: Update a Roxygen config expression

}}
\keyword{internal}
