% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc-function.R
\name{qc}
\alias{qc}
\title{Perform quality control}
\usage{
qc(dnam_ga, ga, phenotype = NULL)
}
\arguments{
\item{dnam_ga}{A data frame of DNA-methylation-based GA. This data frame
must be the output of \code{\link{plec}} function. The rows must be named
according to the sample IDs.}

\item{ga}{A data frame of GA. There is only one column, i.e., \code{GA}, as shown
in \code{ga}. Use \code{data(ga)} to load this data frame. The rows must be named
according to the sample IDs.}

\item{phenotype}{A data frame of phenotype (optional). There is only one
column, i.e., \code{phenotype}, as shown in \code{phenotype}. Use
\code{data(phenotype)} to load this data frame. The rows must be named
according to the sample IDs.}
}
\value{
A ggplot object of calibration plot with RMSE, MAE, and r.
}
\description{
This function evaluates the precision of DNA-methylation-based (DNAm)
gestational age (GA) based on calibration, root mean square error (RMSE),
mean absolute error (MAE), and Pearson's correlation coefficient (r). The
sample identifiers (IDs) are automatically matched among the DNAm-GA, GA,
and phenotype (optional). Only GA from 5 to 44 weeks' gestation are shown in
the calibration plot.
}
\examples{

\donttest{
  beta_values_case <- download_beta_values_case()
  norm_beta_values_case <- bmiq_norm_450k(beta_values_case)
  dnam_ga_case <- plec(norm_beta_values_case)
  
  data(ga)
  ga_case <- ga[phenotype$phenotype == "Case", , drop = FALSE]
  set.seed(1)
  qc(dnam_ga_case, ga_case)
}
}
\keyword{gestational-age}
\keyword{placental-epigenetic-clock}
\keyword{quality-control}
