% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rrr.R
\name{pairwise_plot}
\alias{pairwise_plot}
\title{Pairwise Plots}
\usage{
pairwise_plot(x, y, type = "pca", pair_x = 1, pair_y = 2, rank = "full",
  k = 0, interactive = FALSE, point_size = 2.5)
}
\arguments{
\item{x}{data frame or matrix of predictor variables}

\item{y}{data frame or matrix of response variables}

\item{type}{type of reduced-rank regression model to fit. \code{type = "identity"}, the default, uses \eqn{\mathbf{\Gamma} = \mathbf{I}} to fit a reduced-rank regression. \code{type = "pca"} fits a principal component analysis model as a special case of reduced-rank regression. \code{type = "cva"} fits a canonical variate analysis model as a special case of reduced-rank regression. \code{type = "lda"} fits a linear discriminant analysis model as a special case of reduced-rank regression.}

\item{pair_x}{variable to be plotted on the \eqn{X}-axis}

\item{pair_y}{variable to be plotted on the \eqn{Y}-axis}

\item{rank}{rank of coefficient matrix.}

\item{k}{small constant added to diagonal of covariance matrices to make inversion easier.}

\item{interactive}{logical. If \code{interactive = FALSE}, the default, plots a static pairwise plot. If \code{interactive = FALSE} plots an interactive pairwise plot.}

\item{point_size}{size of points in scatter plot.}
}
\value{
ggplot2 object if \code{interactive = FALSE}; plotly object if \code{interactive = TRUE}.
}
\description{
Pairwise Plots
}
\examples{
data(pendigits)
digits_features <- pendigits[,1:34]
digits_class <- pendigits[,35]
pairwise_plot(digits_features, digits_class, type = "pca", pair_x = 1, pair_y = 3)

library(dplyr)
data(COMBO17)
galaxy <- as_data_frame(COMBO17)
galaxy <- select(galaxy, -starts_with("e."), -Nr, -UFS:-IFD)
galaxy <- na.omit(galaxy)
galaxy_x <- select(galaxy, -Rmag:-chi2red)
galaxy_y <- select(galaxy, Rmag:chi2red)
pairwise_plot(galaxy_x, galaxy_y, type = "cva")

data(iris)
iris_x <- iris[,1:4]
iris_y <- iris[5]
pairwise_plot(iris_x, iris_y, type = "lda")

}
\references{
Izenman, A.J. (2008) \emph{Modern Multivariate Statistical Techniques}. Springer.
}

