% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records.R, R/rtoi.R
\name{names,records-method}
\alias{names,records-method}
\alias{names,rtoi-method}
\alias{names,rtoi}
\alias{names<-,rtoi,character-method}
\alias{names<-,rtoi,character}
\title{Get the name of the object}
\usage{
\S4method{names}{records}(x)

\S4method{names}{rtoi}(x)

\S4method{names}{rtoi,character}(x) <- value
}
\arguments{
\item{x}{a \code{records} or an \code{rtoi} object.}

\item{value}{character argument. The new value for \code{x}.}
}
\value{
a character vector containing the name of
all the names in \code{x}.
}
\description{
A function to get or set the names of an object.
}
\examples{
\dontrun{
# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

names(navarre)
names(navarre) <- "New name"
names(navarre)

rcrds <- records(navarre)

names(rcrds)
}
}
