% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rodionov.R
\name{Rodionov}
\alias{Rodionov}
\title{Rodionov (2004)'s STARS algorithm}
\usage{
Rodionov(data, col, time, l, prob = 0.05, startrow = 1, merge = FALSE)
}
\arguments{
\item{data}{The dataframe to be used.}

\item{col}{The column we are measuring change on.}

\item{time}{The column containing time units (e.g. age of a subsample)}

\item{l}{The cut-off length of a regime; affects sensitivity (see Rodionov, 2004)}

\item{prob}{The p-value for significance of a regime shift. Defaults to p = 0.05.}

\item{startrow}{What row the analysis starts at. Defaults to 1.}

\item{merge}{Sets the result to be either a regime-shift only table (if FALSE), or an addition to the original table (if TRUE)}
}
\value{
If merge = FALSE (default), produces a 2-column table of time (the time value for each regime shift) and RSI (the regime shift index for each regime shift). If merge = TRUE, returns the original dataset with an extra RSI column, giving the regime shift index for each time unit - 0 for non-shift years.
}
\description{
performs STARS analysis (Rodionov, 2004) on a dataset
}
\examples{
Rodionov(lake_data, "DCA1", "Age", l=5)
Rodionov(lake_data, "DCA1", "Age", l=5, prob=0.01, startrow=2, merge=TRUE)
}
