% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applied_reshape.r
\name{chop}
\alias{chop}
\title{Chop of a branch of the tree}
\usage{
chop(.tokens, ...)
}
\arguments{
\item{.tokens}{A tokenIndex}

\item{...}{Arguments passed to tquery. For instance, relation = 'punct' cuts off all punctuation dependencies (in universal dependencies)}
}
\value{
A tokenIndex with the rows of the nodes in the selected branches removed
}
\description{
Using the query language for tquery, chop of the branch down from the node that is found
}
\examples{

spacy_conjunctions <- function(tokens) {
  no_fill = c('compound*','case', 'relcl')
  tq = tquery(label='target', NOT(relation = 'conj'),
              rsyntax::fill(NOT(relation = no_fill), max_window = c(Inf,0)),
              children(relation = 'conj', label='origin',
                       rsyntax::fill(NOT(relation = no_fill), max_window=c(0,Inf))))
  tokens = climb_tree(tokens, tq)
  chop(tokens, relation = 'cc')
}

## spacy tokens for "Bob and John ate bread and drank wine"
tokens = tokens_spacy[tokens_spacy$doc_id == 'text5',]

tokens = spacy_conjunctions(tokens)
tokens
\donttest{
if (interactive()) plot_tree(tokens)
}
}
