% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_reshape.r
\name{subset_nodes}
\alias{subset_nodes}
\title{Subset a select_nodes selection}
\usage{
subset_nodes(.tokens, subset, copy = TRUE)
}
\arguments{
\item{.tokens}{A tokenIndex in which nodes are selected with \link{select_nodes}.}

\item{subset}{A subset expression (that evaluates to a logical vector). The token column for each labeled node in the tquery can be referred to as label$column.}

\item{copy}{If TRUE, make a deep copy of .tokens. Use if output does not overwrite .tokens}
}
\value{
A tokenIndex with a .nodes attribute
}
\description{
Enables more control in reshape operations
}
\examples{
tokens = tokens_spacy[tokens_spacy$doc_id == 'text4',]

## use a tquery to label the nodes that you want to manipulate
tq = tquery(label='verb', children(relation='nsubj'))

## apply query to select nodes
tokens2 = select_nodes(tokens, tq) 

selected_nodes(tokens2)$nodes
tokens2 = subset_nodes(tokens2, verb$relation == 'ROOT')
selected_nodes(tokens2)$nodes
}
