% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{set_formatter_image}
\alias{set_formatter_image}
\title{Set image formatter}
\usage{
set_formatter_image(
  widget,
  column,
  height = "50px",
  width = "50px",
  url_prefix = NULL,
  url_suffix = NULL,
  hoz_align = "center"
)
}
\arguments{
\item{widget}{A \code{\link[=tabulator]{tabulator()}} HTML widget.}

\item{column}{The name of the column the formatter is applied to.}

\item{height}{(character): A CSS value for the height of the image.}

\item{width}{(character): A CSS value for the width of the image.}

\item{url_prefix}{(character): String to add to the start of the cell value
when generating the image src url.}

\item{url_suffix}{(character): String to add to the end of the cell value
when generating the image src url.}

\item{hoz_align}{(character): The horizontal alignment of the column.}
}
\value{
The updated \code{\link[=tabulator]{tabulator()}} HTML widget
}
\description{
Set image formatter
}
\examples{
image_url <- "https://picsum.photos/id/"
image_size <- 100

image_data <- data.frame(
  image = c(88, 98, 102, 201),
  label = c("Pic No. 88", "Pic No. 98", "Pic No. 102", "Pic No 201")
)

tabulator(image_data, tabulator_options(height = "400px")) |>
  set_formatter_image(
    "image",
    height = image_size,
    width = image_size,
    url_prefix = image_url,
    url_suffix = glue::glue("/{image_size}"),
    hoz_align = "left"
  )
}
