% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-cv.R
\name{plot.cv_poisson_rt}
\alias{plot.cv_poisson_rt}
\title{Plot cv_poisson_rt}
\usage{
\method{plot}{cv_poisson_rt}(x, which_lambda = c("cv_scores", "lambda.min", "lambda.1se"), ...)
}
\arguments{
\item{x}{result of cv_estimate_rt of class \code{cv_poisson_rt}}

\item{which_lambda}{select which Rt's to plot.

If not provided, the cross validation score will be plotted. If provided a
list of lambda, the corresponding Rt estimation will be plotted.

If provided a string, it
must be either one of \code{lambda.min}, \code{lambda.1se}, or \code{cv_scores}.
\itemize{
\item If provided \code{lambda.min}, plot Rt which is generated from the lambda that
minimizes the cross validation score.
\item If provided \code{lambda.1se}, plot Rt which is generated from the lambda whose
corresponding cross validation score is 1 standard error away of the
minimal cross validation score.
\item If provided \code{cv_scores}, plot the cross validation score.
\item If NULL, all estimated Rt values are plotted.
}}

\item{...}{Not used.}
}
\value{
a \link[ggplot2:ggplot]{ggplot2::ggplot}
}
\description{
Plot cv_poisson_rt
}
\examples{
y <- c(1, rpois(100, dnorm(1:100, 50, 15) * 500 + 1))
cv <- cv_estimate_rt(y, korder = 1, nfold = 3, nsol = 30)
plot(cv)
plot(cv, which_lambda = cv$lambda[1])
plot(cv, which_lambda = "lambda.min")
plot(cv, which_lambda = "lambda.1se")
plot(cv, NULL)
}
