% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam.R
\name{polar_gam}
\alias{polar_gam}
\title{Polar generalised additive model (polar GAM)}
\usage{
polar_gam(
  formula,
  data,
  origin = NULL,
  fan_lines = c(10, 25),
  AR_start = NULL,
  ...
)
}
\arguments{
\item{formula}{A GAM formula.}

\item{data}{A data set containing the spline coordinates (cartesian coordinates must be in columns named \code{X} and \code{Y}, polar coordinates in columns named \code{angle} and \code{radius}; these are the defaults in data imported with \code{read_aaa()}).}

\item{origin}{The coordinates of the origin as a vector of \code{c(x, y)} coordinates.}

\item{fan_lines}{A numeric vector with two fan lines (the default is
\code{c(10, 25)}).}

\item{AR_start}{The \code{AR.start} argument to be passed to \code{mgcv::bam()}.}

\item{...}{Arguments to be passed to \code{mgcv::bam()}.}
}
\value{
An object of class \code{"gam"} as described in
  \code{\link[mgcv]{gamObject}}.
}
\description{
It fits a generalised additive model (GAM) to transformed polar tongue data
and it returns a model in polar coordinates. Use \code{plot_polar_smooths()}
for plotting.
}
\details{
It is advised to fit a separate model per speaker, unless you have a working
method for inter-speaker normalisation of the coordinates.
}
\examples{
\donttest{
library(dplyr)
tongue_it01 <- filter(tongue, speaker == "it01")
pgam <- polar_gam(Y ~ s(X, by = c2_place) + s(X, word, bs = "fs"),
data = tongue_it01)
}
}
