% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invblock_partition.R
\name{invblock_partition}
\alias{invblock_partition}
\title{Inversion of the 1d block partition}
\usage{
invblock_partition(x, n, L)
}
\arguments{
\item{x}{partition of coefficients by block.}

\item{n}{scale.}

\item{L}{block size.}
}
\description{
Inversion of the 1d block partition
}
\examples{
n <- 8
x <- MakeSignal('Ramp', n)
j0 <- 1
qmf <- MakeONFilter('Haar')
wc <- FWT_PO(x, j0, qmf)
L <- 2
wcb <- block_partition(wc, L)
wcib <- invblock_partition(wcb, n, L)
}
\seealso{
\code{\link{block_partition}}, \code{\link{BlockThresh}}.
}
