% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianMixtures.R
\name{GaussianMixtures}
\alias{GaussianMixtures}
\title{Construct a poset of gaussian mixture models.}
\usage{
GaussianMixtures(maxNumComponents = 1, dim = 1,
                 phi = "default", restarts = 50)
}
\arguments{
\item{maxNumComponents}{the maximum number of gaussian components to
consider in a mixture.}

\item{dim}{the ambient dimension in which the gaussian mixtures reside.
Default is 1, corresponding to gaussian mixtures on the real line.}

\item{phi}{parameter controlling the strength of the sBIC penalty.}

\item{restarts}{the number of random restarts to perform when computing the
MLE.}
}
\value{
An object representing the collection.
}
\description{
Creates an object representing a collection of gaussian mixture models. There
is one model for each fixed number of components from 1 to some specified
maximum. In particular each model is identified by a single number
specifiying the number of components in the model. Models are naturally
ordered by inclusion so that, for example, a model with 2 components comes
before a model with 3 or more components.
}

