#' Sequences of sRNAs from one species
#'
#' This `data.frame` is very useful for the functional demonstration of "srnapredata"
#'
#' @docType data
#' @name F1_sRNA_seq
#' @format A dataframe containing numerous sequences of all sRNAs in "F1" (the S3 generations of Parents (Maternal parent: Triticum turgidum; Male parent: Aegilops tauschii)). However, only 400 sRNAs are selected as test data due to the large data of sRNA.
#' @description The first column of this data set is all sequences from one speceie for the data statistics
#' @source Generated from the S3 generations of Triticum turgidum (AABB) and Aegilops tauschii (DD).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(F1_sRNA_seq)
NULL

#' Sequences of sRNAs from one species
#'
#' This `data.frame` is very useful for the functional demonstration of "srnapredata"
#'
#' @docType data
#' @name P1_sRNA_seq
#' @format A dataframe containing numerous sequences of all sRNAs in "P1" (Male parent: Aegilops tauschii). However, only 400 sRNAs are selected as test data due to the large data of sRNA.
#' @description The first column of this data set is all sequences from one speceie for the data statistics
#' @source Generated from the Aegilops tauschii (DD).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(P1_sRNA_seq)
NULL

#' Sequences of sRNAs from one species
#'
#' This `data.frame` is very useful for the functional demonstration of "srnapredata"
#'
#' @docType data
#' @name P2_sRNA_seq
#' @format A dataframe containing numerous sequences of all sRNAs in "P2" (Maternal parent: Triticum turgidum). However, only 400 sRNAs are selected as test data due to the large data of sRNA.
#' @description The first column of this data set is all sequences from one species for the data statistics
#' @source Generated from the Triticum turgidum (AABB).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(P2_sRNA_seq)
NULL

#' Sequences of miRNAs from one species
#'
#' @docType data
#' @name P2_miRNA_count
#' @format A dataframe containing all miRNAs with count value in "P2" (Maternal parent: Triticum turgidum).
#' @description The first column of this data set is all miRNA sequences from "P2", and other columns are the corresponding count values from different samples
#' @source Generated from the Triticum turgidum (AABB).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(P2_miRNA_count)
NULL

#' Sequences of miRNAs from one species
#'
#' @docType data
#' @name P2_miRNA_rpm
#' @format A dataframe containing all miRNAs with RPM value in "P2" (Maternal parent: Triticum turgidum).
#' @description The first column of this data set is all miRNA sequences from "P2", and other columns are the corresponding RPM values of different samples
#' @source Generated from the Triticum turgidum (AABB).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(P2_miRNA_rpm)
NULL

#' Sequences of miRNAs from one species
#'
#' @docType data
#' @name P1_miRNA_count
#' @format A dataframe containing all miRNAs with count value in "P1" (Male parent: Aegilops tauschii).
#' @description The first column of this data set is all miRNA sequences from "P1", and other columns are the corresponding count values from different samples
#' @source Generated from the Aegilops tauschii (DD).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(P1_miRNA_count)
NULL

#' Sequences of miRNAs from one species
#'
#' @docType data
#' @name P1_miRNA_rpm
#' @format A dataframe containing all miRNAs with RPM value in "P1" (Male parent: Aegilops tauschii).
#' @description The first column of this data set is all miRNA sequences from "P1", and other columns are the corresponding RPM values of different samples
#' @source Generated from the Aegilops tauschii (DD).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(P1_miRNA_rpm)
NULL

#' Sequences of miRNAs from one species
#'
#' @docType data
#' @name F1_miRNA_count
#' @format A dataframe containing all miRNAs with count value in "F1" (the S3 generations of Parents (Maternal parent: Triticum turgidum; Male parent: Aegilops tauschii)).
#' @description The first column of this data set is all miRNA sequences from "F1", and other columns are the corresponding count values from different samples
#' @source Generated from the S3 generations of Triticum turgidum (AABB) and Aegilops tauschii (DD).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(F1_miRNA_count)
NULL

#' Sequences of miRNAs from one species
#'
#' @docType data
#' @name F1_miRNA_rpm
#' @format A dataframe containing all miRNAs with RPM value in "F1" (the S3 generations of Parents (Maternal parent: Triticum turgidum; Male parent: Aegilops tauschii)).
#' @description The first column of this data set is all miRNA sequences from "F1", and other columns are the corresponding RPM values of different samples
#' @source Generated from the S3 generations of Triticum turgidum (AABB) and Aegilops tauschii (DD).
#' @references Li, A., et al., mRNA and Small RNA Transcriptomes Reveal Insights into Dynamic Homoeolog Regulation of Allopolyploid Heterosis in Nascent Hexaploid Wheat. Plant Cell, 2014. 26(5): p. 1878-1900.
#' @examples
#' data(F1_miRNA_rpm)
NULL
