% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sSDR.R
\name{sOLS.comp.d}
\alias{sOLS.comp.d}
\title{Structured OLS (sOLS) outer level BIC criterion to estimate dimension with
eigen-decomposition}
\usage{
sOLS.comp.d(X, sizes)
}
\arguments{
\item{X}{A matrix containing directions estimated from all subpopulations.}

\item{sizes}{A vector with the sample sizes of all subpopulation.}
}
\value{
sOLS.comp.d returns a list containning at least the following
components:
"d", the dimension estimated across subpopulations;
"u", the "d" linearly independent directions among the matrix X.
}
\description{
Structured OLS (sOLS) outer level BIC criterion to estimate dimension with
eigen-decomposition
}
\details{
This function estimates dimension across the subpopulations using
eigen-decomposition. The order of the subpopulations in the "sizes" vector
should match the one in the "X" matrix. Also, this function returns the
linearly independent directions among all subpopulations.
}
\examples{
v1 <- c(1, 1, 0, 0)
v2 <- c(0, 1, 1, 0)
v3 <- c(0, 0, 1, 1)
v4 <- c(1, 1, 1, 1)
m1 <- cbind(v1, v2)
sizes1 <- c(100, 200)
sOLS.comp.d(m1, sizes1)
m2 <- cbind(v1, v2, v3)
sizes2 <- c(100, 200, 500)
sOLS.comp.d(m2, sizes2)
m3 <- cbind(v1, v3, v4)
sizes3 <- c(100, 500, 1000)
sOLS.comp.d(m3, sizes3)
}
\references{
Liu, Y., Chiaromonte, F., and Li, B. (2015). Structured Ordinary
Least Squares: a sufficient dimension reduction approach for regressions with
 partitioned predictors and heterogeneous units. Submitted.
}

