% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sSDR.R
\name{gSIR}
\alias{gSIR}
\title{Groupwise SIR (gSIR) for binary response}
\usage{
gSIR(X, Y, groups, dims)
}
\arguments{
\item{X}{A covariate matrix of n observations and p predictors.}

\item{Y}{A binary response.}

\item{groups}{A vector with the number of predictors in each group.}

\item{dims}{A vector with the dimension (at most 1) for each predictor group.}
}
\value{
gSIR returns a list containning at least the following components:
"b_est", the estimated directions for each group with its own dimension
using gSIR AFTER normalization;
"B", the estimated directions for each group using gSIR BEFORE normalization.
}
\description{
Groupwise SIR (gSIR) for binary response
}
\details{
This function estimates directions for each predictor group using gSIR.
Predictors need to be organized in groups within the "X" matrix, as the
same order saved in "groups". We only allow continuous covariates
in the "X" matrix; while categorical covariates can be handled outside of
gSIR, e.g. structured SIR.
}
\examples{
data <- gen.data(n=1000, binary=TRUE) # generate data
dim(data$X) # covariate matrix of 1000 observations and 15 predictors
length(data$y) # binary response
groups <- c(5, 10) # two predictor groups and their numbers of predictors
dims <- c(1,1) # dimension of each predictor group
est_gSIR<-gSIR(data$X,data$y,groups,dims)
names(est_gSIR)
}
\references{
Guo, Z., Li, L., Lu, W., and Li, B. (2014). Groupwise dimension
reduction via envelope method. Journal of the American Statistical
Association, accepted.
}

