% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumlogchisq.r
\name{sumlogchisq}
\alias{sumlogchisq}
\alias{dsumlogchisq}
\alias{psumlogchisq}
\alias{qsumlogchisq}
\alias{rsumlogchisq}
\title{The sum of the logs of (non-central) chi-squares distribution.}
\usage{
dsumlogchisq(x, wts, df, ncp=0, log = FALSE, order.max=6)

psumlogchisq(q, wts, df, ncp=0, lower.tail = TRUE, log.p = FALSE, order.max=6)

qsumlogchisq(p, wts, df, ncp=0, lower.tail = TRUE, log.p = FALSE, order.max=6)

rsumlogchisq(n, wts, df, ncp=0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{wts}{the vector of weights. 
This is recycled against the \code{df, ncp}, but not against the \code{x,q,p,n}.}

\item{df}{the vector of degrees of freedom. 
This is recycled against the \code{wts, ncp}, but not against the \code{x,q,p,n}.}

\item{ncp}{the vector of non-centrality parameters. 
This is recycled against the \code{wts, df}, but not against the \code{x,q,p,n}.}

\item{log}{logical; if TRUE, densities \eqn{f} are given 
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{order.max}{the order to use in the approximate density,
distribution, and quantile computations, via the Gram-Charlier,
Edeworth, or Cornish-Fisher expansion.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{log.p}{logical; if TRUE, probabilities p are given 
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P[X \le x]}{P[X <= x]}, otherwise, \eqn{P[X > x]}{P[X > x]}.}
}
\value{
\code{dsumlogchisq} gives the density, \code{psumlogchisq} gives the 
distribution function, \code{qsumlogchisq} gives the quantile function, 
and \code{rsumlogchisq} generates random deviates.

Invalid arguments will result in return value \code{NaN} with a warning.
}
\description{
Density, distribution function, quantile function and random
generation for the distribution of the weighted sum of logs of
non-central chi-squares.
}
\details{
Let \eqn{X_i \sim \chi^2\left(\delta_i, \nu_i\right)}{X_i ~ chi^2(delta_i, v_i)}
be independently distributed non-central chi-squares, where \eqn{\nu_i}{v_i}
are the degrees of freedom, and \eqn{\delta_i}{delta_i} are the
non-centrality parameters.  
Let \eqn{w_i} be given constants. Suppose
\deqn{Y = \sum_i w_i \log X_i.}{Y = sum w_i log(X_i).}
Then \eqn{Y}{Y} follows a weighted sum of log of chi-squares distribution.
}
\note{
The PDF, CDF, and quantile function are approximated, via
the Edgeworth or Cornish Fisher approximations, which may
not be terribly accurate in the tails of the distribution.
You are warned.

The distribution parameters are \emph{not} recycled
with respect to the \code{x, p, q} or \code{n} parameters,
for, respectively, the density, distribution, quantile
and generation functions. This is for simplicity of
implementation and performance. It is, however, in contrast
to the usual R idiom for dpqr functions.
}
\examples{
wts <- c(1,-3,4)
df <- c(100,20,10)
ncp <- c(5,3,1)
rvs <- rsumlogchisq(128, wts, df, ncp)
dvs <- dsumlogchisq(rvs, wts, df, ncp)
qvs <- psumlogchisq(rvs, wts, df, ncp)
pvs <- qsumlogchisq(ppoints(length(rvs)), wts, df, ncp)
}
\references{
Pav, Steven. Moments of the log non-central chi-square distribution.
\url{https://arxiv.org/abs/1503.06266}
}
\seealso{
The product of chi-squares to a power,
\code{\link{dprodchisqpow}},
\code{\link{pprodchisqpow}},
\code{\link{qprodchisqpow}},
\code{\link{rprodchisqpow}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{distribution}
