% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/square_bracket.R
\name{[.safeframe}
\alias{[.safeframe}
\alias{sub_safeframe}
\alias{[<-.safeframe}
\alias{[[<-.safeframe}
\alias{$<-.safeframe}
\title{Subsetting of safeframe objects}
\usage{
\method{[}{safeframe}(x, i, j, drop = FALSE)

\method{[}{safeframe}(x, i, j) <- value

\method{[[}{safeframe}(x, i, j) <- value

\method{$}{safeframe}(x, name) <- value
}
\arguments{
\item{x}{a \code{safeframe} object}

\item{i}{a vector of \code{integer} or \code{logical} to subset the rows of the
\code{safeframe}}

\item{j}{a vector of \code{character}, \code{integer}, or \code{logical} to subset the
columns of the \code{safeframe}}

\item{drop}{a \code{logical} indicating if, when a single column is selected, the
\code{data.frame} class should be dropped to return a simple vector, in which
case the \code{safeframe} class is lost as well; defaults to \code{FALSE}}

\item{value}{the replacement to be used for the entries identified in \code{x}}

\item{name}{
    a literal character string or a \link[base]{name} (possibly \link[base]{backtick}
    quoted).  For extraction, this is normally (see under
    \sQuote{Environments}) partially matched to the \code{\link[base]{names}}
    of the object.
  }
}
\value{
If no drop is happening, a \code{safeframe}. Otherwise an atomic vector.
}
\description{
The \verb{[]} and \verb{[[]]} operators for \code{safeframe} objects behaves like for
regular \code{data.frame} or \code{tibble}, but check that tagged variables are not
lost, and takes the appropriate action if this is the case (warning, error,
or ignore, depending on the general option set via \code{\link[=lost_tags_action]{lost_tags_action()}}) .
}
\examples{
if (require(dplyr) && require(magrittr)) {
  ## create a safeframe
  x <- cars \%>\%
    make_safeframe(
      mph = "speed",
      distance = "dist"
    ) \%>\%
    mutate(result = if_else(speed > 50, "fast", "slow")) \%>\%
    set_tags(ticket = "result")
  x

  ## dangerous removal of a tagged column setting it to NULL issues warning
  x[, 1] <- NULL
  x

  x[[2]] <- NULL
  x

  x$speed <- NULL
  x
}
}
\seealso{
\itemize{
\item \code{\link[=lost_tags_action]{lost_tags_action()}} to set the behaviour to adopt when tags are
lost through subsetting; default is to issue a warning
\item \code{\link[=get_lost_tags_action]{get_lost_tags_action()}} to check the current the behaviour
}
}
