% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{sf_delete}
\alias{sf_delete}
\title{Delete Records}
\usage{
sf_delete(
  ids,
  object_name = NULL,
  api_type = c("REST", "SOAP", "Bulk 1.0", "Bulk 2.0"),
  guess_types = TRUE,
  control = list(...),
  ...,
  all_or_none = deprecated(),
  verbose = FALSE
)
}
\arguments{
\item{ids}{\code{vector}, \code{matrix}, \code{data.frame}, or
\code{tbl_df}; if not a vector, there must be a column called Id (case
insensitive) that can be passed in the request.}

\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used along with \code{anytime()} and \code{anydate()}.
If \code{FALSE} then all fields will be returned as character. Specifying
\code{FALSE} helpful when guessing the column data type will result in NA
values and you would like to return the results as strings and then cast in
your script according to your unique specifications.}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream
to \code{\link{sf_bulk_operation}}}

\item{all_or_none}{\code{logical}; allows a call to roll back all changes unless all
records are processed successfully.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Deletes one or more records from your organization’s data.
}
\note{
Because the SOAP and REST calls chunk data into batches of 200 records
the AllOrNoneHeader will only apply to the success or failure of every batch
of records and not all records submitted to the function.
}
\examples{
\dontrun{
n <- 3
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact", 1:n))
new_records <- sf_create(new_contacts, object_name="Contact")
deleted_first <- sf_delete(new_records$id[1], object_name = "Contact")  

# add the control to do an "All or None" deletion of the remaining records
deleted_rest <- sf_delete(new_records$id[2:3], object_name = "Contact", 
                          AllOrNoneHeader = list(allOrNone = TRUE))
}
}
