% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-query.R
\name{sf_query_result_bulk}
\alias{sf_query_result_bulk}
\title{Retrieve the results of a completed bulk query}
\usage{
sf_query_result_bulk(
  job_id,
  batch_id = NULL,
  result_id = NULL,
  guess_types = TRUE,
  bind_using_character_cols = deprecated(),
  batch_size = 50000,
  api_type = c("Bulk 1.0", "Bulk 2.0"),
  verbose = FALSE
)
}
\arguments{
\item{job_id}{\code{character}; the Salesforce Id assigned to a submitted job as
returned by \link{sf_create_job_bulk}. It will start with \code{"750"}.}

\item{batch_id}{\code{character}; the Salesforce Id assigned to a submitted
batch as returned by \link{sf_create_batches_bulk}. It will start with \code{"751"}.}

\item{result_id}{\code{character}; a string returned from
\link{sf_batch_details_bulk} when a query has completed and specifies how to
get the recordset}

\item{guess_types}{\code{logical}; indicating whether or not to use \code{col_guess()}
to try and cast the data returned in the recordset. If \code{TRUE} then
\code{col_guess()} is used along with \code{anytime()} and \code{anydate()}.
If \code{FALSE} then all fields will be returned as character. Specifying
\code{FALSE} helpful when guessing the column data type will result in NA
values and you would like to return the results as strings and then cast in
your script according to your unique specifications.}

\item{bind_using_character_cols}{\code{logical}; an indicator of whether to
cast the data to all character columns to ensure that \code{\link[dplyr:bind]{bind_rows}}
does not fail because two paginated recordsets have differing datatypes for the
same column. Set this to \code{TRUE} rarely, typically only when having this
set to \code{FALSE} returns an error or you want all columns in the data to be
character.}

\item{batch_size}{\code{integer}; the number of individual records to be included in a
single batch uploaded to the Bulk APIs (1.0 or 2.0).}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df}, formatted by Salesforce, containing query results
}
\description{
This function returns the recordset of a bulk query which has already been
submitted to the Bulk 1.0 or Bulk 2.0 API and has completed.
}
\examples{
\dontrun{
my_query <- "SELECT Id, Name FROM Account LIMIT 1000"
job_info <- sf_create_job_bulk(operation = 'query', object = 'Account')
query_info <- sf_submit_query_bulk(job_id = job_info$id, soql = my_query)
result <- sf_batch_details_bulk(job_id = query_info$jobId,
                                batch_id = query_info$id)
recordset <- sf_query_result_bulk(job_id = query_info$jobId,
                                  batch_id = query_info$id,
                                  result_id = result$result)
sf_close_job_bulk(job_info$id)
}
}
\references{
\href{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/asynch_api_bulk_query_intro.htm}{Bulk 1.0 documentation} and \href{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/queries.htm}{Bulk 2.0 documentation}
}
