% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harvest_MMP.R, R/MMSE2SMSE.R, R/SOM2MOM.R,
%   R/SOM2MOM_int.R, R/multiHist2SHist.R
\name{make_Harvest_MMP}
\alias{make_Harvest_MMP}
\alias{MMSE2SMSE}
\alias{salmonMSE-int}
\alias{SOM2MOM}
\alias{make_Stock}
\alias{make_Fleet}
\alias{multiHist2SHist}
\title{Internal salmonMSE functions for converting operating model inputs and outputs}
\usage{
make_Harvest_MMP(SOM, check = TRUE)

MMSE2SMSE(MMSE, SOM, Harvest_MMP, N, stateN, Ford, H, stateH)

SOM2MOM(SOM, check = TRUE)

make_Stock(
  SOM,
  s = 1,
  g = 1,
  r = 1,
  NOS = TRUE,
  stage = c("immature", "return", "escapement")
)

make_Fleet(SOM, s, NOS = TRUE, stage = c("immature", "return", "escapement"))

multiHist2SHist(multiHist, SOM, check = TRUE)
}
\arguments{
\item{SOM}{An object of class \linkS4class{SOM}}

\item{check}{Logical, whether to check the \code{SOM} object using \code{\link[=check_SOM]{check_SOM()}}}

\item{MMSE}{Object of class \link[MSEtool:MMSE-class]{MSEtool::MMSE} returned from MSEtool}

\item{Harvest_MMP}{Optional harvest function created by \code{\link[=make_Harvest_MMP]{make_Harvest_MMP()}}}

\item{N}{Data frame of natural origin abundance at age saved in the \link{salmonMSE_env} environment during the simulation}

\item{stateN}{Data frame of natural origin state variables saved in the \link{salmonMSE_env} environment during the simulation}

\item{Ford}{Data frame of phenotypic trait values saved in the \link{salmonMSE_env} environment during the simulation}

\item{H}{Data frame of hatchery origin abundance at age saved in the \link{salmonMSE_env} environment during the simulation}

\item{stateH}{Data frame of hatchery origin state variables saved in the \link{salmonMSE_env} environment during the simulation}

\item{s}{Integer, the population integer for which to create the Stock or Fleet object}

\item{g}{Integer, the life history group for which to create the Stock object. Not relevant if \code{NOS = FALSE}}

\item{r}{Integer, the hatchery release group for which to create the Stock object. Not relevant if \code{NOS = TRUE}}

\item{NOS}{Logical, whether the Stock or Fleet object corresponds to natural origin or hatchery origin fish}

\item{stage}{Character indicating the corresponding salmon life stage of the Stock or Fleet object}

\item{multiHist}{Class multiHist object returned from MSEtool}
}
\value{
\code{make_Harvest_MMP}: Function of class "MMP" by updating the formal arguments for \code{\link[=Harvest_MMP]{Harvest_MMP()}}

\code{MMSE2SMSE}: \linkS4class{SMSE} object

\code{SOM2MOM}: \link[MSEtool:MOM-class]{MSEtool::MOM} object

\code{make_Stock}: List containing a \link[MSEtool:Stock-class]{MSEtool::Stock} object and accompanying custom parameters list

\code{make_Stock}: List containing a \link[MSEtool:Fleet-class]{MSEtool::Fleet} object and accompanying custom parameters list

\code{multiHist2SHist}: \linkS4class{SHist} object
}
\description{
\itemize{
\item \code{\link[=SOM2MOM]{SOM2MOM()}} converts a salmon operating model (\linkS4class{SOM}) to a multi-stock operating model (\link[MSEtool:MOM-class]{MSEtool::MOM})
\item \code{\link[=make_Stock]{make_Stock()}} creates the \link[MSEtool:Stock-class]{MSEtool::Stock} object (openMSE) corresponding to salmon life stage
\item \code{\link[=make_Fleet]{make_Fleet()}} creates the \link[MSEtool:Fleet-class]{MSEtool::Fleet} object (openMSE) corresponding to the fishery that interacts with the various salmon life stages
\item \code{\link[=multiHist2SHist]{multiHist2SHist()}} converts the openMSE historical reconstruction into a salmon Hist object (\linkS4class{SHist})
\item \code{\link[=MMSE2SMSE]{MMSE2SMSE()}} converts the openMSE projection output, along with additional state variables recorded in \link{salmonMSE_env}, into a salmon MSE object (\linkS4class{SMSE})
\item \code{\link[=make_Harvest_MMP]{make_Harvest_MMP()}} creates a multi-stock management procedure for the harvest component of the operating model by
specifying exploitation rates through updating the formal arguments for \code{\link[=Harvest_MMP]{Harvest_MMP()}}
}

\code{\link[=salmonMSE]{salmonMSE()}} is the wrapper function that coordinates the simulation and the output.
}
