% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessdb.R
\name{sm_write_excel}
\alias{sm_write_excel}
\title{Export Wide Data to Excel}
\usage{
sm_write_excel(
  data,
  ...,
  transpose = FALSE,
  transpose.date.format = "\%d/\%m/\%Y"
)
}
\arguments{
\item{data}{a wide dataset from \code{\link{sm_data}} or reshaped to a wide format with \code{\link{sm_pivot_wider}}.}

\item{\dots}{further arguments to \code{\link[writexl]{write_xlsx}}. As a minimum a path needs to be supplied that ends with the name of the Excel file. See Examples.}

\item{transpose}{logical. If \code{TRUE}, the result is returned in a row-oriented Excel format. The default is column oriented (same as the dataset in R).}

\item{transpose.date.format}{argument passed to \code{\link{sm_transpose}}, setting the format of date columns when data is transposed.}
}
\value{
Writes an Excel file to the specified path (no return value).
}
\description{
This function exports a wide format dataset to a column- (default) or row-oriented Excel format.
}
\examples{
\dontrun{
# Getting electricity indicators from 2000
data <- sm_data("ELECTRICITY", from = 2000)

# Saving to different Excel formats
sm_write_excel(data, "ELECTRICITY.xlsx")
sm_write_excel(data, "ELECTRICITY.xlsx", transpose = TRUE)

# Saving to alternative path
sm_write_excel(data, "C:/Users/.../ELECTRICITY.xlsx")
}

}
\seealso{
\code{\link{sm_transpose}}, \code{\link[writexl]{write_xlsx}}, \code{\link{samadb}}
}
