% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkData.R
\name{checkData}
\alias{checkData}
\title{Compare old and new versions of VADIR to find repeats}
\usage{
checkData(old, new, fix = FALSE, dates = FALSE)
}
\arguments{
\item{old}{Past version of VADIR}

\item{new}{New version of VADIR}

\item{fix}{Logical. Determines whether to automatically remove repeated
responses.}

\item{dates}{Logical. Determines whether to include date variables when
comparing datasets. Recommended to keep \code{FALSE}.}
}
\value{
Returns a message that no repeated responses exist if there are none.
Otherwise, returns either a warning that repeated responses exist, or
returns the new VADIR dataset without repeated responses if \code{fix =
  TRUE}.
}
\description{
Can be used to identify whether a new version of VADIR contains any old
responses. Can also automatically remove repeated responses.
}
