% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatPWR.R
\docType{class}
\name{StatPWR-class}
\alias{StatPWR-class}
\alias{StatPWR}
\title{A Reference Class which contains statistics of a PWR model.}
\description{
StatPWR contains all the statistics associated to a \link[=ParamPWR]{PWR} model.
}
\section{Fields}{

\describe{
\item{\code{z_ik}}{Logical matrix of dimension \eqn{(m, K)} giving the class vector.}

\item{\code{klas}}{Column matrix of the labels issued from \code{z_ik}. Its elements are
\eqn{klas(i) = k}, \eqn{k = 1,\dots,K}.}

\item{\code{mean_function}}{Approximation of the time series given the estimated
parameters. \code{mean_function} is a matrix of size \eqn{(m, 1)}.}

\item{\code{regressors}}{Matrix of size \eqn{(m, K)} giving the values of the
estimated polynomial regression components.}

\item{\code{objective}}{Numeric. Value of the objective function.}
}}

\section{Methods}{

\describe{
\item{\code{computeStats(paramPWR)}}{Method used at the end of the dynamic programming algorithm to compute
statistics based on parameters provided by \code{paramPWR}.}
}}

\seealso{
\link{ParamPWR}
}
