% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arnoldi.R
\name{arnoldi}
\alias{arnoldi}
\alias{lanczos}
\title{Krylov Subspace Spectral Decomposition}
\usage{
arnoldi(
  a,
  b,
  symmetric,
  iter = nrow(a),
  tol = .Machine$double.eps,
  eigen = TRUE,
  orthogonalise = TRUE
)

lanczos(
  a,
  b,
  iter = nrow(a),
  tol = .Machine$double.eps,
  eigen = TRUE,
  orthogonalise = TRUE
)
}
\arguments{
\item{a}{Square numeric matrix.}

\item{b}{Arbitrary numeric non-zero vector used to construct the basis.}

\item{symmetric}{Logical scalar indicating whether 'a' is symmetric. By
default symmetry is checked up to machine precision, which may take a long
time for symmetric matrices.}

\item{iter}{Integer scalar with the maximum number of iterations. Defaults
to the theoretical maximum, i.e. the number of columns in 'a'.}

\item{tol}{Numeric scalar with the desired tolerance. Defaults to the
machine precision.}

\item{eigen}{Logical scalar indicating whether to compute eigenvalues from
the decomposition.}

\item{orthogonalise}{Logical scalar indicating whether to use plain Lanczos
or full reorthogonalisation. Defaults to reorthogonalisation.}
}
\value{
Returns a list with slots \code{"H"} for the Hessenberg form of 'a'
or slots \code{"diagonal"} and \code{"subdiagonal"} for its triangular form,
slot \code{"Q"} with the orthonormal basis, and, if requested, eigenvalues
in the slot \code{"values"}.
}
\description{
Arnoldi iteration and Lanczos method to iteratively approximate the
Hessenberg or tridiagonal form of a matrix \eqn{A}{A} and find its
eigenvalues.
}
\examples{
set.seed(42)
# Compute Hessenberg of a square matrix
A <- matrix(rnorm(9), nrow = 3, ncol = 3)
ks <- arnoldi(A, symmetric = FALSE)

# Compute tridiagonal of a symmetric matrix
A <- crossprod(matrix(rnorm(9), nrow = 3, ncol = 3))
ks <- lanczos(A)
ks <- arnoldi(A, symmetric = TRUE) # Short-hand

}
