% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satdad_Rfunctions.R
\name{plotClev}
\alias{plotClev}
\title{Cleveland's Dot Plots of the tail dependence structure.}
\usage{
plotClev(ds, ind = "all", which = "tsic", labels = TRUE)
}
\arguments{
\item{ds}{An object of class \code{ds}.}

\item{ind}{A character string among "with.singletons" and "all" (without singletons), or an integer in \eqn{\{2,...,d\}} or a list of subsets from  \eqn{\{1,...,d\}}. The default is \code{ind = "all"}.}

\item{which}{A character string among "tsic" (normalized tsic plot), and "ec" (normalized ec plot).}

\item{labels}{A boolean. `TRUE` the default indicates that the names of the subsets are printed. `FALSE` if only points are drawn.}
}
\value{
Draws a Cleveland dot plot of the normalized theoretical tsic when \code{superset = TRUE}, the default value.

Otherwise theoretical normalized ec are drawn.
}
\description{
Global comparison of the theoretical tail superset importance coefficients (tsic) via a Cleveland's Dot Plot.
}
\examples{
## Fix a 6-dimensional asymmetric tail dependence structure
## Two blocks of components are specified
ds6 <- gen.ds(d = 6, sub = list(1:4,5:6))

## Plot the associated Cleveland dot plot
plotClev(ds6)

}
\seealso{
\code{\link[satdad]{plotClevEmp}}
}
\author{
Cécile Mercadier (\code{mercadier@math.univ-lyon1.fr})
}
